/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;

class BreakDictionary {
    private char[] reverseColumnMap = null;
    private static int supportedVersion = 0;
    private int version;
    private CompactByteArray columnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    public final short at(int n2, char c2) {
        byte by = this.columnMap.elementAt(c2);
        return this.at(n2, by);
    }

    public final short at(int n2, int n3) {
        if (this.cellIsPopulated(n2, n3)) {
            return this.internalAt(this.rowIndex[n2], n3 + this.rowIndexShifts[n2]);
        }
        return 0;
    }

    private final short internalAt(int n2, int n3) {
        return this.table[n2 * this.numCols + n3];
    }

    private final boolean cellIsPopulated(int n2, int n3) {
        if (this.rowIndexFlagsIndex[n2] < 0) {
            return n3 == -this.rowIndexFlagsIndex[n2];
        }
        int n4 = this.rowIndexFlags[this.rowIndexFlagsIndex[n2] + (n3 >> 5)];
        return (n4 & 1 << (n3 & 0x1F)) != 0;
    }

    public void readDictionaryFile(DataInputStream dataInputStream) throws IOException {
        char c2;
        this.version = dataInputStream.readInt();
        if (this.version != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + this.version + ") is unsupported", dataInputStream.toString(), "");
        }
        int n2 = dataInputStream.readInt();
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = dataInputStream.readShort();
        }
        n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        for (c2 = '\u0000'; c2 < byArray.length; ++c2) {
            byArray[c2] = dataInputStream.readByte();
        }
        this.columnMap = new CompactByteArray(sArray, byArray);
        this.numCols = dataInputStream.readInt();
        this.numColGroups = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        this.rowIndex = new short[n2];
        for (c2 = '\u0000'; c2 < this.rowIndex.length; ++c2) {
            this.rowIndex[c2] = dataInputStream.readShort();
        }
        n2 = dataInputStream.readInt();
        this.rowIndexFlagsIndex = new short[n2];
        for (c2 = '\u0000'; c2 < this.rowIndexFlagsIndex.length; ++c2) {
            this.rowIndexFlagsIndex[c2] = dataInputStream.readShort();
        }
        n2 = dataInputStream.readInt();
        this.rowIndexFlags = new int[n2];
        for (c2 = '\u0000'; c2 < this.rowIndexFlags.length; ++c2) {
            this.rowIndexFlags[c2] = dataInputStream.readInt();
        }
        n2 = dataInputStream.readInt();
        this.rowIndexShifts = new byte[n2];
        for (c2 = '\u0000'; c2 < this.rowIndexShifts.length; ++c2) {
            this.rowIndexShifts[c2] = dataInputStream.readByte();
        }
        n2 = dataInputStream.readInt();
        this.table = new short[n2];
        for (c2 = '\u0000'; c2 < this.table.length; ++c2) {
            this.table[c2] = dataInputStream.readShort();
        }
        this.reverseColumnMap = new char[this.numCols];
        for (c2 = '\u0000'; c2 < '\uffff'; c2 = (char)(c2 + '\u0001')) {
            byte by = this.columnMap.elementAt(c2);
            if (by == 0) continue;
            this.reverseColumnMap[by] = c2;
        }
        dataInputStream.close();
    }

    public BreakDictionary(InputStream inputStream) throws IOException {
        this.readDictionaryFile(new DataInputStream(inputStream));
    }

    public static void main(String[] stringArray) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String string = stringArray[0];
        BreakDictionary breakDictionary = new BreakDictionary(new FileInputStream(string));
        String string2 = "";
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        PrintWriter printWriter = null;
        if (string2.length() != 0) {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UnicodeLittle"));
        }
        breakDictionary.printWordList("", 0, printWriter);
    }

    public void printWordList(String string, int n2, PrintWriter printWriter) throws IOException {
        if (n2 == -1) {
            System.out.println(string);
            if (printWriter != null) {
                printWriter.println(string);
            }
        } else {
            for (int i2 = 0; i2 < this.numCols; ++i2) {
                if (this.at(n2, i2) == 0) continue;
                this.printWordList(string + this.reverseColumnMap[i2], this.at(n2, i2), printWriter);
            }
        }
    }
}

